@echo off
REM ccresultss 実行用バッチファイル

REM 文字コードをUTF-8に設定（日本語表示のため）
chcp 65001 >nul 2>&1

REM バッチファイルのディレクトリに移動
cd /d "%~dp0" 2>nul || cd /d "%~dp0."

REM バッチファイルのディレクトリパスを変数に保存（スペース対応のため）
set "BATCH_DIR=%~dp0"
REM 末尾のバックスラッシュを削除
if "%BATCH_DIR:~-1%"=="\" set "BATCH_DIR=%BATCH_DIR:~0,-1%"

echo ========================================
echo ccresultss を起動しています
echo ========================================
echo 現在のディレクトリ: "%BATCH_DIR%"
echo.

REM 正しいディレクトリか確認
if not exist "app\requirements.txt" (
    echo エラー: app\requirements.txt が見つかりません
    echo 期待される場所: "%BATCH_DIR%\app\requirements.txt"
    echo.
    pause
    exit /b 1
)

REM Pythonの確認
python --version >nul 2>&1
if %errorlevel% neq 0 (
    echo エラー: Pythonが見つかりません
    echo Python 3.9以上をインストールしてください（推奨: Python 3.12 もしくは 3.13）
    echo インストール方法は PythonInstallationGuide.md を参照してください
    pause
    exit /b 1
)

REM Pythonバージョンの取得
set "TEMP_VER_FILE=%TEMP%\ccresultss_python_ver_%RANDOM%.txt"
python --version >"%TEMP_VER_FILE%" 2>&1
for /f "tokens=2" %%i in ('type "%TEMP_VER_FILE%"') do set PYTHON_VER=%%i
del "%TEMP_VER_FILE%" 2>nul

if not defined PYTHON_VER (
    echo エラー: Pythonバージョンを取得できませんでした
    pause
    exit /b 1
)

echo Pythonバージョン: %PYTHON_VER%

REM バージョン解析（3.12以上かどうかを確認）
for /f "tokens=1 delims=." %%a in ("%PYTHON_VER%") do set VER_MAJOR=%%a
for /f "tokens=2 delims=." %%b in ("%PYTHON_VER%") do set VER_MINOR=%%b

REM バージョン警告（推奨バージョンでない場合）
if defined VER_MINOR (
    if %VER_MINOR% lss 9 (
        echo 警告: Python 3.9未満は動作しない可能性があります
    ) else if %VER_MINOR% geq 14 (
        echo 警告: Python 3.14以上では一部のライブラリがビルドできない可能性があります
        echo       推奨: Python 3.12 もしくは 3.13
    ) else if %VER_MINOR% lss 12 (
        echo 注意: Python 3.12 もしくは 3.13 の使用を推奨します
    )
)

REM 仮想環境のディレクトリを設定
set "VENV_DIR=%BATCH_DIR%\.venv"

REM 仮想環境が存在しない場合は作成
if not exist "%VENV_DIR%" (
    echo 仮想環境を作成しています（ccresultss フォルダ配下の作業）...
    python -m venv "%VENV_DIR%"
    if %errorlevel% neq 0 (
        echo 仮想環境の作成に失敗しました
        pause
        exit /b 1
    )
    echo 仮想環境の作成が完了しました。
)

REM 仮想環境をアクティベート
call "%VENV_DIR%\Scripts\activate.bat"
if %errorlevel% neq 0 (
    echo 仮想環境のアクティベートに失敗しました
    pause
    exit /b 1
)

REM pip、setuptools、wheelをアップグレード
python -m pip install --quiet --upgrade pip setuptools wheel >nul 2>&1

REM ライブラリのインストール
echo ライブラリをインストールしています（ccresultss フォルダ配下の作業）...
if defined VER_MINOR (
    if %VER_MINOR% geq 12 (
        python -m pip install --quiet --disable-pip-version-check --no-warn-script-location --prefer-binary -r "app\requirements.txt"
    ) else (
        python -m pip install --quiet --disable-pip-version-check --no-warn-script-location --only-binary :all: -r "app\requirements.txt"
    )
) else (
    python -m pip install --quiet --disable-pip-version-check --no-warn-script-location --prefer-binary -r "app\requirements.txt"
)

if %errorlevel% neq 0 (
    echo インストールに失敗しました。再試行しています...
    python -m pip install --disable-pip-version-check --no-warn-script-location --prefer-binary -r "app\requirements.txt"
    if %errorlevel% neq 0 (
        echo インストールに失敗しました。上記のエラーメッセージを確認してください。
        pause
        exit /b 1
    )
)

REM アプリケーションを実行
echo.
echo アプリケーションを起動しています...
if not exist "app\src\main.py" (
    echo エラー: app\src\main.py が見つかりません
    pause
    exit /b 1
)

python "app\src\main.py"
set EXIT_CODE=%errorlevel%

if %EXIT_CODE% neq 0 (
    echo.
    echo アプリケーションがエラーコード %EXIT_CODE% で終了しました。
    pause
    exit /b %EXIT_CODE%
)

echo.
echo アプリケーションが正常に終了しました。
echo.
pause
