# -*- coding: utf-8 -*-
"""
パス管理クラス
"""

from pathlib import Path
from config import Config


class PathManager:
    """パス管理クラス"""
    
    def __init__(self):
        """パス管理の初期化"""
        self.base_dir = self._get_base_directory()
        self.logs_dir = self._get_app_directory() / Config.LOGS_DIR
        self.screenshots_dir = self.base_dir / Config.SCREENSHOTS_DIR
        self.templates_dir = self._get_templates_directory()
        self.config_path = self.base_dir / Config.CONFIG_FILE
    
    @staticmethod
    def _get_src_directory() -> Path:
        """srcフォルダのパスを取得"""
        return Path(__file__).parent.absolute()
    
    @staticmethod
    def _get_app_directory() -> Path:
        """appフォルダのパスを取得"""
        return Path(__file__).parent.parent.absolute()
    
    @staticmethod
    def _get_base_directory() -> Path:
        """ベースディレクトリを取得（ccresultssフォルダ）"""
        return Path(__file__).parent.parent.parent.absolute()
    
    @staticmethod
    def _get_templates_directory() -> Path:
        """テンプレートディレクトリを取得"""
        # app/templates を返す
        return PathManager._get_app_directory() / Config.TEMPLATES_DIR
    
    def ensure_directories(self) -> None:
        """必要なディレクトリを作成（logsとscreenshotsのみ）
        
        templates_dirは作成しない（プログラムに含まれるため）
        config.iniは既にccresultssフォルダに配置されている
        """
        self.logs_dir.mkdir(parents=True, exist_ok=True)
        self.screenshots_dir.mkdir(parents=True, exist_ok=True)

